//package globalExamples;

import oracle.olapi.data.source.DataProvider;

import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

import oracle.olapi.metadata.MetadataObject;

/**
 * Complete code for Example 2-2, Getting the Type of an MdmSource, in
 * Chapter 2, Understanding OLAP API Metadata, in the Oracle OLAP
 * Developer's Guide to the OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 * @author Oracle Corporation
 */
public class GettingTypeOfMdmSource
{
  public GettingTypeOfMdmSource()
  {
  }

  public void run(String [] args)
  {
    Context10g context = new Context10g(args, false);
    DataProvider dp = context.getDataProvider();


    // Get the MdmPrimaryDimension for the Global schema dimension of product
    // values.
    MdmPrimaryDimension mdmProdDim =
                             context.getMdmPrimaryDimensionByName("PRODUCT");


    MdmPrimaryDimension mdmCustDim =
                              context.getMdmPrimaryDimensionByName("CUSTOMER");
    MdmLevelHierarchy mdmShipmentsRollup = (MdmLevelHierarchy)
                     context.getHierarchyByName(mdmCustDim, "SHIPMENTS_ROLLUP");
    MdmLevel mdmWarehouse = context.getLevelByName(mdmShipmentsRollup, "WAREHOUSE");

    context.println("\nExample 2-2, Getting the Type of an MdmSource.");

    // The following line is the code of Example 2-2.
    MetadataObject mdmWarehouseType = mdmWarehouse.getType();

    context.println(mdmWarehouseType.getID());
  }

  public static void main(String[] args)
  {
    new GettingTypeOfMdmSource().run(args);
  }
}
